package gov.va.med.mhv.usermgmt.data.repository;

import gov.va.med.mhv.usermgmt.data.model.UserProfileAccessControl;
import gov.va.med.mhv.usermgmt.data.model.UserProfileAccessRole;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserProfileAccessRoleRepository extends JpaRepository<UserProfileAccessControl, Long> {
	
	@Query("select u from UserProfileAccessRole u where u.userProfile.userName = :userName")
	public List<UserProfileAccessRole> findUserProfileAccessRoleByUserName(@Param("userName") String userName);
}
